/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _SEQUENCEACCUMULATOR_H_
#define _SEQUENCEACCUMULATOR_H_

#include "../accumulator.h"

/**
 * Pour chaque squence gnre, cette classe va accumuler chaque points de la squence.
 */
class SequenceAccumulator : public Accumulator
{

public:
	SequenceAccumulator( const FractalParameters * _fractal_parameters )
		:	Accumulator( _fractal_parameters )
	{
	}

	void accumulate( const Point&, const PointsSequence& _sequence )
	{
		for( unsigned int i = 0 ; i < (unsigned int)_sequence.size() ; ++i )
		{
			const unsigned int buffer_position = bufferPosition( _sequence[i] );
			
			if( buffer_position < m_buffer_size )
				m_buffer[ buffer_position ] ++;
		}
	}
};

#endif //_SEQUENCEACCUMULATOR_H_