/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _FRACTAL_MT_H_
#define _FRACTAL_MT_H_

#include "fractal_thread.h"

#include "pointsgenerators/imagepointsgenerator.h"

/**
 * Gnration d'une fractale sur plusieurs threads.
 * Pour cela cette classe va gnrer plusieurs Fractal_Thread ayant des paramtres adapts et rassemblera ces fractales en une seule  la fin.
 */
template< typename TSequence, typename TPointsGenerator, typename TAccumulator >
class Fractal_MT_Mother : public Fractal
{
protected:
	typedef Fractal_Thread< TSequence, TPointsGenerator, TAccumulator > TFractal_Thread;

private:
	bool m_is_thread_not_generated, m_is_thread_deleted;

protected:
	QVector< TFractal_Thread* >		m_fractal_threads;
	TFractal_Thread					m_fractal_result;
	unsigned int					m_thread_count;

public:
	Fractal_MT_Mother( const FractalParameters& _fractal_parameters, const unsigned int _thread_count );

	virtual qreal progress() const;
	virtual void stop();
	virtual QImage toImage( const Palette& _palette ) const;

	virtual int load( QFile& _file );
	virtual int save( QFile& _file ) const;

protected:
	/**
	 * \brief Gnre les threads
	 */
	virtual void generateThreads();
	/**
	 * \brief Construit la fractale rsultante en fonction des fractales calcules dans les diffrents threads
	 */
	virtual void generateFractalResult();

	virtual void run();

};

/**
 * Cas gnral
 */
template< typename TSequence, typename TPointsGenerator, typename TAccumulator >
class Fractal_MT : public Fractal_MT_Mother< TSequence, TPointsGenerator, TAccumulator >
{
public:
	Fractal_MT( const FractalParameters& _fractal_parameters, const unsigned int _thread_count );
};

//Spcialistation partielle pour le cas d'une gnration des points  partir de l'image et d'une accumulation au centre
/**
 * Cas de la gnration de points sur une image et d'une accumulation au centre
 */
template< typename TSequence >
class Fractal_MT< TSequence, ImagePointsGenerator, CenterAccumulator > : public Fractal_MT_Mother< TSequence, ImagePointsGenerator, CenterAccumulator >
{
public:
	Fractal_MT( const FractalParameters& _fractal_parameters, const unsigned int _thread_count );

protected:
	void generateThreads();
	void generateFractalResult();
};

//Dfinitions en inline car templates
#include "fractal_mt.inl"

#endif //_FRACTAL_MT_H_