/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _FRACTAL_THREAD_H_
#define _FRACTAL_THREAD_H_

#include "../fractal.h"

/**
 * Gnration d'une fractale sur un seul threads.
 */
template< typename TSequence, typename TPointsGenerator, typename TAccumulator >
class Fractal_Thread : public Fractal
{
private:
	TSequence			m_sequence;
	TPointsGenerator	m_points_generator;
	TAccumulator		m_accumulator;
		
public:
	Fractal_Thread( const FractalParameters& _fractal_parameters )
		:	Fractal( _fractal_parameters )
		,	m_sequence( &m_fractal_parameters )
		,	m_points_generator( &m_fractal_parameters )
		,	m_accumulator( &m_fractal_parameters )
	{
	}

	void accumulate( const Fractal_Thread& _fractal )
	{
		((Accumulator*)&m_accumulator)->accumulate( _fractal.m_accumulator );
	}
	void accumulateAt( const unsigned int _position, const Fractal_Thread& _fractal )
	{
		((Accumulator*)&m_accumulator)->accumulateAt( _position, _fractal.m_accumulator );
	}
	

	virtual qreal progress() const
	{
		return m_points_generator.progress();
	}

	virtual QImage toImage( const Palette& _palette ) const
	{
		return m_accumulator.toImage( _palette );
	}

	virtual int load( QFile& _file )
	{
		return m_accumulator.load( _file );
	}
	virtual int save( QFile& _file ) const
	{
		return m_accumulator.save( _file );
	}

protected:
	virtual void run()
	{
		m_points_generator.init();
		while( ! m_stop && ! m_points_generator.end() )
		{
			const Point point = m_points_generator.next();
			const PointsSequence& points_sequence = m_sequence.compute( point );

			m_accumulator.accumulate( point, points_sequence );
		}
		
		quit();
	}
};

#endif //_FRACTAL_THREAD_H_