/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _POINTSGENERATOR_H_
#define _POINTSGENERATOR_H_

#include "point.h"
#include "../fractalparameters.h"

#include <QtCore/QSize>

/**
 * Gnrateur de points.
 * Classe abstraite.
 */
class PointsGenerator
{
protected:
	const FractalParameters * m_fractal_parameters;

public:
	/**
	 * \brief Constructeur.
	 * \param _fractal_parameters Pointeur vers les paramtres de la fractale.
	 */
	PointsGenerator( const FractalParameters * _fractal_parameters )
	{
		m_fractal_parameters = _fractal_parameters;
	}

	/**
	 * \brief Retourne la progression actuelle de la gnration de points.
	 * \return Progression actuelle.
	 */
	virtual qreal progress() const = 0;

	/**
	 * \brief Initialise la gnration de points.
	 */
	virtual void init() = 0;
	/**
	 * \brief Renvoie le prochain point.
	 * \return Prochain point.
	 */
	virtual Point next() = 0;
	/**
	 * \brief Retourne si la fin de gnration est arrive.
	 * \return True si le dernier point a t gnr.
	 */
	virtual bool end() = 0;

};

#endif //_POINTSGENERATOR_H_