/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _IMAGEPOINTSGENERATOR_H_
#define _IMAGEPOINTSGENERATOR_H_

#include "../pointsgenerator.h"

/**
 * Gnre les points au centre de chaque pixel de l'image rsultante.
 */
class ImagePointsGenerator : public PointsGenerator
{
private:
	unsigned int m_progress;
	qreal m_x, m_y;
	qreal m_x_step, m_y_step;

public:
	ImagePointsGenerator( const FractalParameters * _fractal_parameters )
		:	PointsGenerator( _fractal_parameters )
	{
		m_progress = 0;
	}

	qreal progress() const
	{
		return m_progress / (qreal)( m_fractal_parameters->imageSize().width() * m_fractal_parameters->imageSize().height() );
	}

	void init()
	{
		m_x_step = m_fractal_parameters->zone().width() / (qreal)( m_fractal_parameters->imageSize().width() );
		m_y_step = m_fractal_parameters->zone().height() / (qreal)( m_fractal_parameters->imageSize().height() );

		//Centre du premier pixel
		m_x = m_fractal_parameters->zone().x() + m_x_step * 0.5;
		m_y = m_fractal_parameters->zone().y() + m_y_step * 0.5;

		m_progress = 0;
	}

	Point next()
	{
		Point point( m_x , m_y );

		m_x += m_x_step;
		if( m_x > m_fractal_parameters->zone().x() + m_fractal_parameters->zone().width() )
		{
			m_x = m_fractal_parameters->zone().x() + m_x_step * 0.5;
			m_y += m_y_step;
		}

		m_progress++;

		return point;
	}

	bool end()
	{
		return m_y > m_fractal_parameters->zone().y() + m_fractal_parameters->zone().height();
	}
};

#endif //_IMAGEPOINTSGENERATOR_H_