/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _RANDOMPOINTSGENERATOR_H_
#define _RANDOMPOINTSGENERATOR_H_

#include "../pointsgenerator.h"

#include <QtCore/QThread>

/**
 * Gnre un nombre dfini de points alatoires.
 */
class RandomPointsGenerator : public PointsGenerator
{
protected:
	quint64 m_points_generated;
	qreal m_inv_rand_max;

public:
	RandomPointsGenerator( const FractalParameters * _fractal_parameters )
		:	PointsGenerator( _fractal_parameters )
	{
		m_points_generated = 0;
	}

	qreal progress() const
	{
		return m_points_generated / (qreal)m_fractal_parameters->pointsNumber();
	}

	void init()
	{
		qsrand( (unsigned int)QThread::currentThreadId() );

		m_inv_rand_max = 1.0 / (qreal)((quint64)RAND_MAX+2);
		m_points_generated = 0;
	}

	Point next()
	{
		m_points_generated++;
		return Point(	  (qrand()+1) * m_inv_rand_max * m_fractal_parameters->zone().width()  + m_fractal_parameters->zone().x()
						, (qrand()+1) * m_inv_rand_max * m_fractal_parameters->zone().height() + m_fractal_parameters->zone().y() );
	}

	bool end()
	{
		return m_points_generated == m_fractal_parameters->pointsNumber();
	}
};

#endif //_RANDOMPOINTSGENERATOR_H_