/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _TESTPOINTSGENERATOR_
#define _TESTPOINTSGENERATOR_

#include "randompointsgenerator.h"

#include <cmath>

/**
 * Classe de test pour une gnration de points moins alatoire, cela ne fonctionne pas  merveille pour l'instant
 */
class TestPointsGenerator : public RandomPointsGenerator
{
protected:
	Point m_point;

public:
	TestPointsGenerator( const FractalParameters * _fractal_parameters )
		:	RandomPointsGenerator( _fractal_parameters )
	{ 
	}

	Point next()
	{
		Point next_point;
		if( qrand() % 5 != 0 ) //1 fois sur 5
		{
			next_point = m_point;

			next_point += 2.0f * Point(		cos( qrand() * m_inv_rand_max * 2.0 * 3.14159265 )
										,	sin( qrand() * m_inv_rand_max * 0.1 ) );
		}
		else
		{
			next_point = RandomPointsGenerator::next();
		}
		m_point = next_point;
		return next_point;
	}
};

#endif //_TESTPOINTSGENERATOR_