/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _MANDELBROT_H_
#define _MANDELBROT_H_

#include "../sequence.h"

/**
 * Gnre une squence de Mandelbrot.
 * En considrant les points comme des complex, le point suivant revient  point^2+constante
 */
class Mandelbrot : public Sequence
{
private:
	Point m_constant_point;

public:
	Mandelbrot( const FractalParameters * _fractal_parameters )
		:	Sequence( _fractal_parameters )
	{
	}

protected:
	virtual Point init( const Point& _init_point )
	{
		m_constant_point = _init_point;
		return _init_point;
	}
	virtual Point next( const Point& _point )
	{
		return Point(	( _point.x() * _point.x() - _point.y() * _point.y() ) + m_constant_point.x(),
						( _point.y() * _point.x() * 2.0 ) + m_constant_point.y() );
	}
	virtual bool end( const Point& _point )
	{
		return _point.x() * _point.x() + _point.y() * _point.y() > 4.0;
	}
};

#endif //_MANDELBROT_H_