/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#include "palette.h"

#include <QtGui/QPainter>
#include <QtAlgorithms>

Palette::Palette( const QColor _color_begin, const QColor _color_end )
{
	m_gradient.setColorAt( 0.0, _color_begin );
	m_gradient.setColorAt( 1.0, _color_end );
}

void Palette::setColor( qreal _position, QColor _color )
{
	Q_ASSERT( _position >= 0.0 && _position <= 1.0 );
	m_gradient.setColorAt( _position, _color );
}
void Palette::removeColorAt( unsigned int _index )
{
	QGradientStops stops = m_gradient.stops();
	Q_ASSERT( _index < (unsigned int)stops.size() );
	stops.remove( _index );
	m_gradient.setStops( stops );
}
QColor Palette::colorAt( unsigned int _index ) const
{
	const QGradientStops& stops = m_gradient.stops();
	Q_ASSERT( _index < (unsigned int)(stops.size()) );
	
	return stops[_index].second.rgba();
}
	
	
void Palette::setColorAt( unsigned int _index, QColor _color )
{
	QGradientStops stops = m_gradient.stops();
	Q_ASSERT( _index < (unsigned int)stops.size() );
	stops[ _index ].second = _color;
	m_gradient.setStops( stops );
}



qreal Palette::colorPosition( unsigned int _index ) const
{
	const QGradientStops& stops = m_gradient.stops();
	Q_ASSERT( _index < (unsigned int)(stops.size()) );
	
	return stops[_index].first;
}
inline static bool compareGradientStop( const QGradientStop& _gradient_stop_1, const QGradientStop& _gradient_stop_2 )
{
	return _gradient_stop_1.first < _gradient_stop_2.first;
}
void Palette::setColorPosition( unsigned int _index, qreal _position )
{
	QGradientStops stops = m_gradient.stops();
	Q_ASSERT( _index > 0 && _index < (unsigned int)(stops.size() - 1) );
	stops[ _index ].first = qBound( 0.0, _position, 1.0 );
	qSort( stops.begin(), stops.end(), compareGradientStop );
	m_gradient.setStops( stops );
}

QImage Palette::generateImage( unsigned int _width, unsigned int _height ) const
{
	QImage image( _width, _height, QImage::Format_ARGB32_Premultiplied );
	QPainter painter( &image );
	QLinearGradient gradient( m_gradient );
	gradient.setStart( 0.0, 0.0 );
	gradient.setFinalStop( (qreal)_width, 0.0 );
	painter.fillRect( 0, 0, _width, _height, gradient );
	return image;
}

int Palette::load( QFile& _file )
{
	//Lecture du nombre de stops
	unsigned int stops_size;
	if( _file.read( (char*)&stops_size, sizeof( unsigned int ) ) != sizeof( unsigned int ) )
		return 1;

	//Lecture des stops
	QGradientStops stops;
	for( unsigned int i = 0 ; i < stops_size ; ++i )
	{
		QGradientStop stop;
		if( _file.read( (char*)&stop, sizeof( QGradientStop ) ) != sizeof( QGradientStop ) )
			return 1;
		stops.push_back( stop );
	}

	m_gradient.setStops( stops );
	return 0;
}
int Palette::save( QFile& _file ) const
{
	//Ecriture du nombre de stops
	unsigned int stops_size = m_gradient.stops().size();
	if( _file.write( (const char*)&stops_size, sizeof( unsigned int ) ) != sizeof( unsigned int ) )
		return 1;

	//Ecriture des stops
	for( unsigned int i = 0 ; i < stops_size ; ++i )
	{
		if( _file.write( (const char*)&m_gradient.stops()[i], sizeof( QGradientStop ) ) != sizeof( QGradientStop ) )
			return 1;

	}
	return 0;
}
