/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _PALETTE_H_
#define _PALETTE_H_

#include <QtCore/QFile>
#include <QtGui/QLinearGradient>

/**
 * Palette de couleur.
 * Elle se rsume en un dgrad de couleurs.
 */
class Palette
{
private:
	QLinearGradient m_gradient;

public:
	/**
	 * \brief Constructeur.
	 * \param _color_begin Couleur de dbut.
	 * \param _color_end Couleur de fin.
	 */
	Palette( const QColor _color_begin = Qt::black, const QColor _color_end = Qt::white );

	/**
	 * \brief Applique une couleur  une position. Si la position existe dj, change la couleur, sinon rajoute une nouvelle position.
	 * \param _position Position [0.0, 1.0].
	 * \param _color Couleur.
	 */
	void setColor( qreal _position, QColor _color );
	/**
	 * \brief Supprime la ime couleur du dgrad.
	 * \param _index Index de la couleur.
	 */
	void removeColorAt( unsigned int _index );
	/**
	 * \brief retourne la ime couleur du dgrad.
	 * \param _index Index de la couleur.
	 * \return Couleur  cette position.
	 */
	QColor colorAt( unsigned int _index ) const;
	/**
	 * \brief Fixe la ime couleur du dgrad.
	 * \param _index Index de la couleur.
	 * \param _color Couleur.
	 */
	void setColorAt( unsigned int _index, QColor _color );
	/**
	 * \brief Retourne la position de la ime couleur.
	 * \param _index Index de la couleur.
	 * \return Position.
	 */
	qreal colorPosition( unsigned int _index ) const;
	/**
	 * \brief Fixe la position de la ime couleur.
	 * \param _index Index de la couleur.
	 * \param _position Nouvelle position.
	 */
	void setColorPosition( unsigned int _index, qreal _position );
	
	/**
	 * \brief Accs.
	 * \return Le dgrad linaire utilis par la palette.
	 */
	const QLinearGradient& linearGradient() const { return m_gradient; }

	/**
	 * \brief Gnre une image contenant le dgrad en horizontal.
	 * \param _width Largeur de l'image.
	 * \param _height Hauteur de l'image.
	 * \return Image gnre.
	 */
	QImage generateImage( unsigned int _width, unsigned int _height = 1 ) const;

	/**
	 * \brief Charge une palette depuis un fichier.
	 * \param _file Fichier ouvert en lecture.
	 * \return 0 si russite, sinon code d'erreur
	 */
	int load( QFile& _file );
	/**
	 * \brief Sauvegarde une palette dans un fichier.
	 * \param _file Fichier ouvert en criture.
	 * \return 0 si russite, sinon code d'erreur
	 */
	int save( QFile& _file ) const;

};

#endif //_PALETTE_H_