/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _ZONE_H_
#define _ZONE_H_

/**
 * Zone de calcul d'une fractale.
 */
class Zone
{
private:
	qreal m_x, m_y;
	qreal m_width, m_height;

public:
	/**
	 * \brief Constructeur par dfaut.
	 */
	Zone()
	{
	}
	/**
	 * \brief Constructeur.
	 * \param _x Dbut de la zone en x.
	 * \param _y Dbut de la zone en y.
	 * \param _width Largeur de la zone.
	 * \param _height Hauteur de la zone.
	 */
	Zone( qreal _x, qreal _y, qreal _width, qreal _height )
	{
		m_x			= _x;
		m_y			= _y;
		m_width		= _width;
		m_height	= _height;
	}

	/**
	 * \brief Accs.
	 * \return Dbut de la zone en x.
	 */
	qreal x() const { return m_x; }
	/**
	 * \brief Accs.
	 * \return Dbut de la zone en y.
	 */
	qreal y() const { return m_y; }
	/**
	 * \brief Accs.
	 * \return Largeur de la zone.
	 */
	qreal width() const { return m_width; }
	/**
	 * \brief Accs.
	 * \return Hauteur de la zone.
	 */
	qreal height() const { return m_height; }

	/**
	 * \brief Accs.
	 * \param _x Dbut de la zone en x.
	 */
	void setX( qreal _x ) { m_x = _x; }
	/**
	 * \brief Accs.
	 * \param _y Dbut de la zone en y.
	 */
	void setY( qreal _y ) { m_y = _y; }
	/**
	 * \brief Accs.
	 * \param _width Largeur de la zone.
	 */
	void setWidth( qreal _width ) { m_width = _width; }
	/**
	 * \brief Accs.
	 * \param _height Hauteur de la zone.
	 */
	void setHeight( qreal _height ) { m_height = _height; }

	/**
	 * \brief Oprateur.
	 * \param _zone Zone  comparer.
	 */
	bool operator!=( const Zone& _zone ) const { return m_x != _zone.m_x || m_y != _zone.m_y || m_width != _zone.m_width || m_height != _zone.m_height; }
};

#endif //_ZONE_H_