/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#include "optionswidget.h"

#include <QtCore/QThread>
#include <QtGui/QMessageBox>
#include <QtOpenGL/QGLShaderProgram>
#include <QtOpenGL/QGLPixelBuffer>


OptionsWidget::OptionsWidget( QWidget *_parent, Qt::WFlags _flags )
	:	QDockWidget( _parent, _flags )
{
	ui.setupUi( this );

	//Initialisation au nombre idal de threads
	int thread_count = QThread::idealThreadCount();
	if( thread_count != 0 ) ui.thread_count_spinBox->setValue( thread_count );

	connect( ui.use_shaders_checkBox, SIGNAL( stateChanged( int ) ), this, SLOT( useShadersOnStateChange( int ) ) );
}

QString OptionsWidget::typeName() const
{
	return ui.fractal_type_comboBox->currentText();
}
unsigned int OptionsWidget::threadsCount() const
{
	return ui.thread_count_spinBox->value();
}
bool OptionsWidget::useShaders() const
{
	return ui.use_shaders_checkBox->checkState() == Qt::Checked;
}

void OptionsWidget::changeEvent( QEvent* _event )
{
	QDockWidget::changeEvent( _event );
	switch( _event->type() )
	{
    case QEvent::LanguageChange :
		{
			int save_fractal_type_comboBox_index = ui.fractal_type_comboBox->currentIndex();
			ui.retranslateUi( this );
			ui.fractal_type_comboBox->setCurrentIndex( save_fractal_type_comboBox_index );
		}
		break;
	default:
		break;
    }
}

void OptionsWidget::useShadersOnStateChange( int _state )
{
	if( _state == Qt::Checked )
	{
		//Test de la prsence de l'extension pbuffer
		if( ! QGLPixelBuffer::hasOpenGLPbuffers() )
		{
			QMessageBox::StandardButton button = QMessageBox::warning( this, tr( "Attention" ), tr( "Votre ordinateur ne semble pas grer les \"pixel buffer\", tes-vous sr de vouloir activer cette option ?"), QMessageBox::Yes | QMessageBox::No );
			if( button == QMessageBox::No )
			{
				ui.use_shaders_checkBox->setCheckState( Qt::Unchecked );
				return;
			}
		}
		//Cration temporaire d'un environnement de rendu OpenGL
		QGLPixelBuffer test_pixel_buffer( 4, 4 );
		test_pixel_buffer.makeCurrent();
		//Test de la prsence des shaders
		if( ! QGLShaderProgram::hasOpenGLShaderPrograms() )
		{
			QMessageBox::StandardButton button = QMessageBox::warning( this, tr( "Attention" ), tr( "Votre ordinateur ne semble pas grer les \"shaders\", tes-vous sr de vouloir activer cette option ?"), QMessageBox::Yes | QMessageBox::No );
			if( button == QMessageBox::No )
			{
				ui.use_shaders_checkBox->setCheckState( Qt::Unchecked );
				return;
			}
		}
	}
}