/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _OPTIONSWIDGET_H_
#define _OPTIONSWIDGET_H_

#include "ui_options.h"

/**
 * Gestion des options.
 * Se rsume au type de la fractale, le nombre de threads utiliss et l'utilisation des shaders si possible.
 */
class OptionsWidget : public QDockWidget
{
	Q_OBJECT

private:
	Ui::OptionsWidget ui;

public:
	/**
	 * \brief Constructeur.
	 * \param _parent Widget parent.
	 * \param _flags Flags du widget.
	 */
	OptionsWidget( QWidget* _parent = 0, Qt::WFlags _flags = 0 );

	/**
	 * \brief Accs.
	 * \return Nom du type de fracale.
	 */
	QString typeName() const;
	/**
	 * \brief Accs.
	 * \return Nombre de threads.
	 */
	unsigned int threadsCount() const;
	/**
	 * \brief Accs.
	 * \return True s'il faut utiliser les shaders.
	 */
	bool useShaders() const;

protected:
	void changeEvent( QEvent* _event );

private slots:
	/**
	 * \brief Teste la prsence des shaders sur le system quand on essaye de cocher l'option.
	 * \param _state Etat de l'option.
	 */
	void useShadersOnStateChange( int _state );
};

#endif //_OPTIONSWIDGET_H_