/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _PALETTEEDITOR_H_
#define _PALETTEEDITOR_H_

#include "../core/palette.h"

#include <QtGui/QFrame>
#include <QtGui/QMouseEvent>

/**
 * Editeur de palette.
 * La souris va permettre d'diter une palette : Clic gauche pour ajouter ou dplacer une couleur, clic droit pour diter une couleur, clic milieu pour supprimer une couleur.
 */
class PaletteEditor : public QFrame
{
	Q_OBJECT

private:
	Palette m_palette;
	int m_move_index;

public:
	/**
	 * \brief Constructeur.
	 * \param _parent Widget parent.
	 * \param _flags Flags du widget.
	 */
	PaletteEditor( QWidget* _parent = 0, Qt::WFlags _flags = 0 );

	/**
	 * \brief Accs.
	 * \return Palette de couleurs.
	 */
	const Palette& palette() const { return m_palette; }	

protected:
	virtual void paintEvent( QPaintEvent * _event );

	virtual void mouseMoveEvent( QMouseEvent* _event );
	virtual void mousePressEvent( QMouseEvent* _event );
	virtual void mouseReleaseEvent( QMouseEvent* _event );

private:
	/**
	 * \brief Ajoute un cercle  un QPainterPath.
	 * Cette fonction va permettre de tester si on clique sur un cercle et les dessiner.
	 * \param _painter_path QPainterPath  qui on va ajouter un cercle.
	 * \param _position Centre du nouveau cercle.
	 */
	void addEllipse( QPainterPath& _painter_path, qreal _position );

public slots:
	/**
	 * \brief Accs.
	 * \param _palette Palette de couleurs.
	 */
	void setPalette( const Palette& _palette ) { m_palette = _palette; repaint(); };

signals:
	/**
	 * \brief Signal mis lors d'une modification de la palette.
	 * \param _palette Palette de couleurs.
	 */
	void paletteChanged( const Palette& _palette );
};

#endif //_PALETTEEDITOR_H_