/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#include "palettewidget.h"

#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtGui/QFileDialog>
#include <QtGui/QMessageBox>

PaletteWidget::PaletteWidget( QWidget *_parent, Qt::WFlags _flags )
	:	QDockWidget( _parent, _flags )
{
	ui.setupUi( this );

	m_palette_editor = new PaletteEditor( this );
	
	connect( m_palette_editor, SIGNAL( paletteChanged( const Palette& ) ), this, SLOT( paletteOnChange( const Palette& ) ) );
	connect( ui.update_pushButton, SIGNAL( clicked() ), this, SLOT( updateOnClick() ) );

	connect( ui.save_pushButton, SIGNAL( clicked() ), this, SLOT( save() ) );
	connect( ui.open_pushButton, SIGNAL( clicked() ), this, SLOT( load() ) );

	ui.verticalLayout->insertWidget( 0, m_palette_editor );

	m_directory = ".";
}

PaletteWidget::~PaletteWidget()
{
	delete m_palette_editor;
}

void PaletteWidget::changeEvent( QEvent* _event )
{
	QDockWidget::changeEvent( _event );
	switch( _event->type() )
	{
    case QEvent::LanguageChange :
        ui.retranslateUi( this );
        break;
	default:
		break;
    }
}

void PaletteWidget::updateOnClick()
{
	emit paletteChanged( m_palette_editor->palette() );
}

void PaletteWidget::paletteOnChange( const Palette& _palette )
{
	if( ui.auto_update_checkBox->checkState() == Qt::Checked )
	{
		emit paletteChanged( _palette );
	}
}

void PaletteWidget::load()
{
	QString file_name = QFileDialog::getOpenFileName( this, tr( "Ouvrir une palette" ), m_directory, tr( "Palettes (*.palette)" ) );
	if ( ! file_name.isNull() )
	{
		m_directory = file_name;
		QFile file( file_name );
		if( ! file.open( QFile::ReadOnly ) )
		{
			QMessageBox::warning(this, tr( "Erreur" ), tr( "Impossible de lire le fichier %1 :\n%2." ).arg( file_name ).arg( file.errorString() ) );
			return;
		}

		Palette palette;

		if( palette.load( file ) != 0 )
		{
			QMessageBox::warning(this, tr( "Erreur" ), tr( "Erreur de lecture." ) );
			return;
		}

		m_palette_editor->setPalette( palette );
		paletteOnChange( palette );
	}
}
void PaletteWidget::save()
{
	QString file_name = QFileDialog::getSaveFileName( this, tr( "Enregistrer la palette" ), m_directory, tr( "Palettes (*.palette)" ) );
	if ( ! file_name.isNull() )
	{
		m_directory = file_name;
		QFile file( file_name );
		if( ! file.open( QFile::WriteOnly  ) )
		{
			QMessageBox::warning(this, tr( "Erreur" ),tr( "Impossible d'crire le fichier %1 :\n%2." ).arg( file_name ).arg( file.errorString() ) );
			return;
		}

		if( m_palette_editor->palette().save( file ) != 0 )
		{
			QMessageBox::warning(this, tr( "Erreur" ), tr( "Erreur d'criture." ) );
			return;
		}
	}
}