/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _PALETTEWIDGET_H_
#define _PALETTEWIDGET_H_

#include "ui_palette.h"

#include "paletteeditor.h"

/**
 * Gestion de palettes.
 * Contient un diteur de palette, la possibilit de charger ou sauvegarder une palette et une option pour emettre automatiquement le changement de palette.
 */
class PaletteWidget : public QDockWidget
{
	Q_OBJECT

private:
	Ui::PaletteWidget ui;

	PaletteEditor* m_palette_editor;
	
	QString m_directory;

public:
	/**
	 * \brief Constructeur.
	 * \param _parent Widget parent.
	 * \param _flags Flags du widget.
	 */
	PaletteWidget( QWidget* _parent = 0, Qt::WFlags _flags = 0 );
	/**
	 * \brief Destructeur.
	 */
	~PaletteWidget();

	/**
	 * \brief Accs.
	 * \return Palette de couleurs.
	 */
	const Palette& palette() const { return m_palette_editor->palette(); }
	/**
	 * \brief Accs.
	 * \param _palette Palette de couleurs.
	 */
	void setPalette( const Palette& _palette ) { m_palette_editor->setPalette( _palette ); }
	
protected:
	void changeEvent( QEvent* _event );

private slots:
	void updateOnClick();
	void paletteOnChange( const Palette& _palette );

public slots:
	/**
	 * \brief Charge la palette.
	 */
	void load();
	/**
	 * \brief Sauvegarde la palette.
	 */
	void save();

signals:
	/**
	 * \brief Signal mis lors d'une modification de la palette.
	 * \param _palette Palette de couleurs.
	 */
	void paletteChanged( const Palette& _palette );
};

#endif //_PALETTEWIDGET_H_