/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#include "parameterswidget.h"

ParametersWidget::ParametersWidget( QWidget *_parent, Qt::WFlags _flags )
	:	QDockWidget( _parent, _flags )
{
	ui.setupUi( this );

	keepRatioChanged( ui.keep_ratio_checkBox->checkState() );

	m_zones_index = 0;
	m_zones.push_back( Zone( ui.zone_x_doubleSpinBox->value(), ui.zone_y_doubleSpinBox->value(), ui.zone_width_doubleSpinBox->value(), ui.zone_height_doubleSpinBox->value() ) );

	connect( ui.keep_ratio_checkBox, SIGNAL( stateChanged( int ) ), this, SLOT( keepRatioChanged( int ) ) );
	connect( ui.before_pushButton, SIGNAL( clicked() ), this, SLOT( backZone() ) );
	connect( ui.after_pushButton, SIGNAL( clicked() ), this, SLOT( nextZone() ) );
}

void ParametersWidget::setFractalParameters( const FractalParameters& _fractal_parameters )
{
	ui.zone_x_doubleSpinBox->setValue(		_fractal_parameters.zone().x() );
	ui.zone_y_doubleSpinBox->setValue(		_fractal_parameters.zone().y() );
	ui.zone_width_doubleSpinBox->setValue(	qMax( _fractal_parameters.zone().width(), 0.00000001 ) ); //Limitation de la zone  0.00000001
	ui.zone_height_doubleSpinBox->setValue(	qMax( _fractal_parameters.zone().height(), 0.00000001 ) );
	ui.image_width_spinBox->setValue(		_fractal_parameters.imageSize().width() );
	ui.image_height_spinBox->setValue(		_fractal_parameters.imageSize().height() );
	ui.points_number_spinBox->setValue(		_fractal_parameters.pointsNumber() / 1000 );
	ui.sequence_max_spinBox->setValue(		_fractal_parameters.sequenceMax() );
}

FractalParameters ParametersWidget::toFractalParameters() const
{
	return FractalParameters(		Zone( ui.zone_x_doubleSpinBox->value(), ui.zone_y_doubleSpinBox->value(), ui.zone_width_doubleSpinBox->value(), ui.zone_height_doubleSpinBox->value() )
								,	QSize( ui.image_width_spinBox->value(), ui.image_height_spinBox->value() )
								,	(quint64)ui.points_number_spinBox->value()*(quint64)1000
								,	ui.sequence_max_spinBox->value() );
}

void ParametersWidget::changeEvent( QEvent* _event )
{
	QDockWidget::changeEvent( _event );
	switch( _event->type() )
	{
    case QEvent::LanguageChange :
        ui.retranslateUi( this );
        break;
	default:
		break;
    }
}

void ParametersWidget::addZone( const Zone& _zone )
{
	if( _zone != m_zones[ m_zones_index ] )
	{
		m_zones_index++;
		m_zones.resize( m_zones_index );
		m_zones.push_back( _zone );
		ui.before_pushButton->setEnabled( true );
		ui.after_pushButton->setEnabled( false );
	}
}

void ParametersWidget::imageWidthChanged( int value )
{
	disconnect( ui.image_height_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageHeightChanged( int ) ) );
	ui.image_height_spinBox->setValue( value * ( 1.0 / m_image_ratio ) );
	connect( ui.image_height_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageHeightChanged( int ) ) );
}

void ParametersWidget::imageHeightChanged( int value )
{
	disconnect( ui.image_width_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageWidthChanged( int ) ) );
	ui.image_width_spinBox->setValue( value * m_image_ratio );
	connect( ui.image_width_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageWidthChanged( int ) ) );
}

void ParametersWidget::keepRatioChanged( int value )
{
	if( value == Qt::Checked )
	{
		m_image_ratio = (qreal)ui.image_width_spinBox->value() / (qreal)ui.image_height_spinBox->value();
		connect( ui.image_width_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageWidthChanged( int ) ) );
		connect( ui.image_height_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageHeightChanged( int ) ) );
	}
	else
	{
		m_image_ratio = (qreal)ui.image_width_spinBox->value() / (qreal)ui.image_height_spinBox->value();
		disconnect( ui.image_width_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageWidthChanged( int ) ) );
		disconnect( ui.image_height_spinBox, SIGNAL( valueChanged( int ) ), this, SLOT( imageHeightChanged( int ) ) );
	}
}

void ParametersWidget::backZone()
{
	if( m_zones_index > 0 )
	{
		m_zones_index--;
		ui.zone_x_doubleSpinBox->setValue(		m_zones[ m_zones_index ].x() );
		ui.zone_y_doubleSpinBox->setValue(		m_zones[ m_zones_index ].y() );
		ui.zone_width_doubleSpinBox->setValue(	m_zones[ m_zones_index ].width() );
		ui.zone_height_doubleSpinBox->setValue(	m_zones[ m_zones_index ].height() );
		ui.after_pushButton->setEnabled( true );
	}
	if( m_zones_index == 0 )
	{
		ui.before_pushButton->setEnabled( false );
	}
}
void ParametersWidget::nextZone()
{
	if( m_zones_index < (unsigned int)m_zones.size()-1 )
	{
		m_zones_index++;
		ui.zone_x_doubleSpinBox->setValue(		m_zones[ m_zones_index ].x() );
		ui.zone_y_doubleSpinBox->setValue(		m_zones[ m_zones_index ].y() );
		ui.zone_width_doubleSpinBox->setValue(	m_zones[ m_zones_index ].width() );
		ui.zone_height_doubleSpinBox->setValue(	m_zones[ m_zones_index ].height() );
		ui.before_pushButton->setEnabled( true );
	}
	if( m_zones_index == (unsigned int)m_zones.size()-1 )
	{
		ui.after_pushButton->setEnabled( false );
	}
}
