/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _PARAMETERSWIDGET_H_
#define _PARAMETERSWIDGET_H_


#include "ui_parameters.h"

#include "../core/fractalparameters.h"

/**
 * Gestion des paramtres de la fractale
 */
class ParametersWidget : public QDockWidget
{
	Q_OBJECT

private:
	Ui::ParametersWidget ui;

	qreal m_image_ratio;
	unsigned int m_zones_index;
	QVector<Zone> m_zones;

public:
	/**
	 * \brief Constructeur.
	 * \param _parent Widget parent.
	 * \param _flags Flags du widget.
	 */
	ParametersWidget( QWidget* _parent = 0, Qt::WFlags _flags = 0 );

	/**
	 * \brief Accs.
	 * \return Paramtres de la fractale.
	 */
	FractalParameters toFractalParameters() const;
	/**
	 * \brief Accs.
	 * \param _fractal_parameters Paramtres de la fractale.
	 */
	void setFractalParameters( const FractalParameters& _fractal_parameters );
	
protected:
	void changeEvent( QEvent* _event );

public slots:
	/**
	 * \brief Ajoute une nouvelle zone.
	 * Toute les zones sont navigables grce aux boutons "Avant" et "Aprs"
	 * \param _zone Nouvelle zone.
	 */
	void addZone( const Zone& _zone );

private slots:
	void imageWidthChanged( int );
	void imageHeightChanged( int );
	void keepRatioChanged( int );

	void backZone();
	void nextZone();
};

#endif //_PARAMETERSWIDGET_H_