/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _PIXMAPLABEL_H_
#define _PIXMAPLABEL_H_

#include <QtGui/QWidget>
#include <QtGui/QPixmap>

/**
 * Gestion de l'affichage d'une image
 */
class PixmapLabel : public QWidget
{
	Q_OBJECT

private:
	QPixmap	m_pixmap;
	qreal	m_scale_factor;
	
	qreal	m_scale_min;
	qreal	m_scale_max;
	qreal	m_scale_step;

	bool m_select;
	QPoint m_select_start, m_select_end;

public:
	/**
	 * \brief Constructeur.
	 * \param _parent Widget parent.
	 * \param _flags Flags du widget.
	 */
	PixmapLabel( QWidget* _parent = 0, Qt::WFlags _flags = 0 );

	/**
	 * \brief Accs.
	 * \return Image affiche.
	 */
	const QPixmap&	pixmap()		const { return m_pixmap; }
	/**
	 * \brief Accs.
	 * \return Facteur de zoom.
	 */
	qreal			scaleFactor()	const { return m_scale_factor; }
	/**
	 * \brief Accs.
	 * \return Zoom minimum.
	 */
	qreal			scaleMin()		const { return m_scale_min; }
	/**
	 * \brief Accs.
	 * \return Zoom maximum.
	 */
	qreal			scaleMax()		const { return m_scale_max; }
	/**
	 * \brief Accs.
	 * \return Le pas dans le changement de zoom.
	 */
	qreal			scaleStep()		const { return m_scale_step; }
	
	/**
	 * \brief Affiche une image.
	 * \param _pixmap Image  afficher.
	 * \param _scale_factor Zoom.
	 */
	void setPixmap( const QPixmap& _pixmap, qreal _scale_factor );
	/**
	 * \brief Accs.
	 * \param _scale_min Zoom minimum.
	 */
	void setScaleMin(	qreal _scale_min	) { m_scale_min		= _scale_min; if( m_scale_factor < m_scale_min ) updateScale( m_scale_min ); }
	/**
	 * \brief Accs.
	 * \param _scale_max Zoom maximum.
	 */
	void setScaleMax(	qreal _scale_max	) { m_scale_max		= _scale_max; if( m_scale_factor > m_scale_max ) updateScale( m_scale_max ); }
	/**
	 * \brief Accs.
	 * \param _scale_step Le pas dans le changement de zoom.
	 */
	void setScaleStep(	qreal _scale_step	) { m_scale_step	= _scale_step; }
	
	
protected:
	virtual void paintEvent( QPaintEvent * _event );
	virtual void wheelEvent( QWheelEvent * _event );
	virtual void mouseMoveEvent( QMouseEvent * _event );
	virtual void mousePressEvent( QMouseEvent * _event );
	virtual void mouseReleaseEvent( QMouseEvent * _event );
	
public slots:
	/**
	 * \brief Met  jour l'image affiche sans rien changer d'autre.
	 * \param _pixmap Image.
	 */
	void updatePixmap( const QPixmap& _pixmap );
	/**
	 * \brief Met  jour le zoom.
	 * \param _scale_factor Facteur de zoom.
	 */
	void updateScale( qreal _scale_factor );

signals:
	/**
	 * \brief Signal mis lors d'une modification de l'image ou du zoom.
	 * \param _scale_factor Nouveau facteur de zoom.
	 * \param _scale Changement dans le facteur de zoom.
	 * \param _positionEndroit o la modification a eu lieu.
	 */
	void updated( qreal _scale_factor, qreal _scale, QPoint _position );
	/**
	 * \brief Signal mis lors d'une slection.
	 * \param _select_start Point en haut  gauche de slection.
	 * \param _select_end Point en bas  droite de slection.
	 */
	void selected( QPointF _select_start, QPointF _select_end );

};

#endif //_PIXMAPLABEL_H_
