/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _MAINWINDOW_H_
#define _MAINWINDOW_H_

#include "ui_mainwindow.h"

#include "gui/pixmapviewer.h"
#include "gui/parameterswidget.h"
#include "gui/optionswidget.h"
#include "gui/palettewidget.h"

#include "core/fractal.h"
#include "core/palette.h"

#include "core/fractals/sequences/mandelbrot.h"
#include "core/fractals/pointsgenerators/imagepointsgenerator.h"
#include "core/fractals/pointsgenerators/randompointsgenerator.h"
#include "core/fractals/pointsgenerators/testpointsgenerator.h"
#include "core/fractals/accumulators/centeraccumulator.h"
#include "core/fractals/accumulators/sequenceaccumulator.h"

#include "core/fractals/fractal_thread.h"
#include "core/fractals/fractal_mt.h"
#include "core/fractals/fractal_gl.h"

#include <QtCore/QTime>
#include <QtCore/QTimer>
#include <QtCore/QTranslator>
#include <QtGui/QPushButton>
#include <QtGui/QProgressBar>
#include <QtGui/QFileDialog>
#include <QtGui/QMessageBox>

/**
 * Fentre principale du logiciel.
 */
class MainWindow : public QMainWindow
{
	Q_OBJECT

private:
	Ui::MainWindowClass ui;

	QWidget* m_main_widget;
	QVBoxLayout* m_layout;

	//Visionneur d'images
	PixmapViewer* m_pixmap_viewer;

	//Dock widgets
	ParametersWidget* m_parameters_widget;
	OptionsWidget* m_options_widget;
	PaletteWidget* m_palette_widget;


	//StatusBar
	QStatusBar* m_status_bar;
	QLabel *m_fractal_type_label, *m_image_size_label, *m_image_scale_label;
	
	//Compute widgets
	QPushButton* m_compute_button, *m_stop_button;
	QProgressBar* m_compute_progressBar;
	QHBoxLayout* m_compute_layout;

	
	QTranslator *m_translator, *m_global_translator;
	
	QString m_directory;
	
	bool		m_current_fractal_use_shaders	,	m_computing_fractal_use_shaders;
	QString		m_current_fractal_type			,	m_computing_fractal_type;
	Fractal*	m_current_fractal				, *	m_computing_fractal;

	QTime m_time;
	QTimer* m_timer;

public:
	/**
	 * \brief Constructeur.
	 * \param _parent Widget parent.
	 * \param _flags Flags du widget.
	 */
	MainWindow( QWidget* _parent = 0, Qt::WFlags _flags = 0 );
	/**
	 * \brief Destructeur.
	 */
	~MainWindow();

protected:
	void changeEvent( QEvent* _event );

private:
	bool allocFractal( Fractal*& _fractal, const FractalParameters& _fractal_parameters, const QString& _fractal_type, const bool _use_shaders = false, const unsigned int _thread_count = 4 );
	void showErrorFile( const QFile& _file );

private slots:	
	void computeClicked();
	/**
	 * \brief Lance le calcul de la fractale.
	 */
	void computeFractal();
	/**
	 * \brief Stoppe le calcul de la fractale.
	 */
	void stopFractal();
	void finishFractal();
	/**
	 * \brief Affiche l'image calcule.
	 * \param _palette Palette utilise pour l'affichage
	 */
	void setFractalImage( const Palette& _palette );
	/**
	 * \brief Met  jour l'image affiche.
	 * \param _palette Palette utilise pour l'affichage
	 */
	void updateFractalImage( const Palette& _palette );
	void updateProgress();
	
	void imageChanged( const QPixmap& _pixmap );
	void imageScaleChanged( qreal _scale_factor );
	void imageSelected( QPointF _select_start, QPointF _select_end );

	void about();
	void aboutQt();
	/**
	 * \brief Met  jour la langue en franais.
	 */
	void setLanguageFr();
	/**
	 * \brief Met  jour la langue en anglais.
	 */
	void setLanguageEn();

	/**
	 * \brief Charge une fractale.
	 */
	void load();
	/**
	 * \brief Sauvegarde une fractale.
	 */
	void save();
	/**
	 * \brief Exporte une image de la fractale.
	 */
	void saveToImage();

};

#endif // _MAINWINDOW_H_
