/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file app.h
 * \brief fichier le plus intressant, il lie tous les lments entre eux
 * \author Pierre Schwartz
 * \version 1.0
 */


#ifndef H__APP_H
#define H__APP_H

#include <QtGui/QWidget>
#include <QtGui/QImage>
#include <QtGui/QProgressBar>
#include <QtGui/QMainWindow>
#include <QtGui/QPushButton>
#include <QtGui/QSpinBox>
#include <QtGui/QComboBox>
#include <QtGui/QCheckBox>
#include <QtGui/QSlider>
#include <QtGui/QLineEdit>
#include <QtGui/QStatusBar>

#include "colormaker.h"
#include "fractale.h"
#include "zoomableimage.h"
#include "networkinput.h"
#include "triplex.h"

/*! 
 * \class App
 * \brief classe principale de l'application. Elle consiste en une mainWindow Qt avec les mthodes de gnration des fractales
 * \author Pierre Schwartz
 * \version 1.0
 */
class App : public QMainWindow{
	Q_OBJECT

	public:
		App(QWidget *parent = 0);
		~App();

	// un signal pour avertir de l'avancement du calcul
	signals:
		void processFinishing(int newValue);

	public slots :
		
		void s_colorate_darkBody();
		void s_colorate_gray();
		void s_colorate_full();
		void s_generate();
		void s_zoom(int, int);
		void s_unzoom(int, int);
		void s_render();
		void s_changeFractale(int);
		void s_displayPointsAleatoires(bool);
		void s_enableNetwork(bool);
		void s_deleteLastNetwork();
		void s_addNetwork();
		void s_receiveMessageFromNetwork(QString&);

		void s_run_dynamic_coloration();
		void s_displayRealCoordinates(int, int);
		void s_saveConfig();
		void s_loadConfig();
		
		void save();
		void about();

		void setMaxValue(long i){
			maxValue = i;
		}
		void myEmitProcess(int i){
			emit processFinishing(i);
		}

	private:
		// images de travail
		QImage *coloredImage, *calculatedImage;
		QVector<QVector<int> > threeDrendering;
		QVector<QVector<triplex> > normalMap;

		// zone de rendu
		ZoomableImage *renderingImage;

		//widgets classique pour l'UI
		QProgressBar *bar;
		QPushButton *calculateButton;
		QSpinBox *iterations;
		QComboBox *sizes, *fractalType;

		// boutons de coloration
		QPushButton *darkBodyBtn, *grayBtn, *fullBtn;
		QCheckBox *showAnimation;
		QWidget *colorationWidget;
		QRectF currentWindow;
		QList<QPushButton*> colorationButtons;

		QMap<QString, fractale*> pluginFractales;

		// docks
		QDockWidget *dockColoration;
		QDockWidget *windowDock;
		QDockWidget *iterationsDock;

		// type de rendu
		QRadioButton *parPixel, *parPointsAleatoires;
		QSpinBox *aleatoiresPoints;

		// cration de l'interface
		void createActions();
		void createMenu();	
		void setCurrentWindow(QRectF&);
		QAction *saveAct, *quitAct, *aboutAct, *saveConfigAct, *loadConfigAct;

		// rseau
		QList<NetworkInput*> networkAddresses;
		QVBoxLayout *vbnetworkDock;
		QPushButton *addNetwork;
		QPushButton *clearNetwork;
		QCheckBox *useNetwork;
		bool isNetworkUsed;

		QSize currentSize;

		/*! 
		 * \brief
		 * Liste de toutes les palettes de couleurs vectorielles
		 */
		QStringList palettesListe;
		long maxValue;

		void applyStyle();
		void buildUI();
		void connectSignals();
		void collectVectorialPalets();
		void collectPluginFractales();
		QStringList collectNetworkAgents();
		void setNetworkList(QList<QString>&);
		void enableColorationButtons(bool);

		void colorate(colorMaker&);
		void generateStartFractaleWindows();
		void generateFractale(fractale&);
		void generateBuddhaBrot();
		void generateHexaMandelBrot();
		void generateMandelBrot();
		void generateNewton();
		void generateTricorn();
		void generateSharingan();
		void generateBateauEnFeu();
		void generatePlugged(QString&);
		void generateJulia(std::complex<float>);	
		void generateMandel3D();

		void runLightning();

		// zones de slection variables, les noms doivent tre rutilisables
		QLineEdit *windowX1, *windowY1, *windowX2, *windowY2;

		// barre d'tat
		QStatusBar *statusBar;
		QLabel *statusBarLabel;
};

#endif
