/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file bateauenfeu.cpp
 * \brief corps de la fractale du bateau en feu
 * \author Pierre Schwartz
 * \version 1.0
 */


#include "bateauenfeu.h"

bateauEnFeu::bateauEnFeu(std::complex<float>& c, long i):fractale(c,i){
}

bateauEnFeu::~bateauEnFeu(){
}

std::complex<float> inline bateauEnFeu::next(std::complex<float>& c){
	std::complex<float> pt = std::complex<float>(fabs(c.real()), fabs(c.imag()));
	return tmp = pt * pt + start;
}
bool bateauEnFeu::stop(){
	return nbIterations >= maxIterations || (tmp.real()*tmp.real()+tmp.imag()*tmp.imag()> 4);
}

std::complex<float> inline bateauEnFeu::renderingDestination(std::complex<float>&){
	return start;
}
