/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file bateauenfeu.h
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__bateauEnFeu__
#define H__bateauEnFeu__

#include "fractale.h"


/*! \class bateauEnFeu
   * \brief Classe de description de l'ensemble du bateau en feu
   * \image html bateauEnFeu.png
   */
class bateauEnFeu : public fractale{
public:
	bateauEnFeu(std::complex<float>&, long);
	~bateauEnFeu();
	std::complex<float> next(std::complex<float>&);
	bool stop();
	std::complex<float> renderingDestination(std::complex<float>&);
	inline bool isVerticalSymetric(){return false;}
	inline bool isImpair(){return false;}

	bateauEnFeu* clone(){
		bateauEnFeu *b = new bateauEnFeu(start, maxIterations);
		return b;
	}

	QString getName(){
		return QString("bateau");
	}

	static QRectF getBestWindow(){
		return QRectF(-1.75,-.125,.25,.25);
	}
};

#endif

