/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/
/*!
 * \file commandlinearguments.cpp
 * \brief corps de l'analyse des paramtres de la ligne de commande
 * \author Pierre Schwartz
 * \version 1.0
 */


#include "commandlinearguments.h"

/*! 
* \brief Constructeur,  partir des arguments du main
*/
CommandLineArguments::CommandLineArguments(int argc, char **argv){
	for (int i=0; i<argc; i++)
		data << QString(argv[i]);
}

CommandLineArguments::~CommandLineArguments(){
}

/*! 
* \brief rcuprer le nom de la fractale  calculer
*/
QString CommandLineArguments::getFractale(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--fractale="))){
			return constIterator->mid(QString("--fractale=").length());
		}
	
	return QString();
}

/*! 
* \brief rcuprer le nom du fichier dans lequel il faut calculer l'image
*/
QString CommandLineArguments::getOutput(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--output="))){
			return constIterator->mid(QString("--output=").length());
		}
	
	return QString();
}

/*! 
* \brief rcupre le caractre alatoire ou point  point du rendu
*/
bool CommandLineArguments::getAleatoire(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--random="))){
			if (constIterator->mid(QString("--random=").length()) == QString("true"))
				return true;
			else
				return false;
		}
	
	return false;
}

/*! 
* \brief permet de savoir si l'appel est en webservice ou pas
*/
bool CommandLineArguments::isNetworkAgent(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--runas="))){
			if (constIterator->mid(QString("--runas=").length()) == QString("netagent"))
				return true;
			else
				return false;
		}
	
	return false;
}

/*! 
* \brief permet d'obtenir le fentrage de rendu
*/
QRectF CommandLineArguments::getWindow(){
	QString sDisplay;
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--window="))){
			 sDisplay = constIterator->mid(QString("--window=").length());
			 QStringList l = sDisplay.split(QChar(':'));
			 if (l.length() == 4)
				 return QRectF(l[1].toFloat(), l[0].toFloat(), l[3].toFloat(), l[2].toFloat());
		}	
	
	return QRectF(-2,-2,4,4);
}

/*! 
* \brief permet d'obtenir la rsolution souhaite
*/
QSize CommandLineArguments::getResolution(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--reso="))){
			int reso = constIterator->mid(QString("--reso=").length()).toInt();			 
			return QSize(reso, reso);
		}
	
	return QSize(128,128);
}

/*! 
* \brief permet d'obtenir le nombre d'itrations max des suites fractales
*/
int CommandLineArguments::getIterations(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--iterations=")))
			return constIterator->mid(QString("--iterations=").length()).toInt();
	
	return 70;
}

/*! 
* \brief permet d'obtenir le dcalage du dbut du rendu lors d'un rendu point  point
*/
int CommandLineArguments::getOffset(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--offset=")))
			return constIterator->mid(QString("--offset=").length()).toInt();
	
	return 1;
}

/*! 
* \brief permet d'obtenir le pas du rendu lors d'un rendu point  point
*/
int CommandLineArguments::getStep(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--step=")))
			return constIterator->mid(QString("--step=").length()).toInt();
	
	return 1;
}

/*! 
* \brief permet d'obtenir le nombre de points alatoires  considrer
*/
long CommandLineArguments::getRandomCount(){
	QStringList::const_iterator constIterator;
    for (constIterator = data.constBegin(); constIterator != data.constEnd();  ++constIterator)
		if ( constIterator->startsWith(QString("--random=")))
			return constIterator->mid(QString("--random=").length()).toLong();
	
	return 1000;
}