/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

#ifndef H__configurationloader__
#define H__configurationloader__

#include <QtCore>

class ConfigurationLoader{

public :
	ConfigurationLoader();
	ConfigurationLoader(QString&);
	long getIterations();
	QRectF getWindow();
	bool getUseRandom();
	long getRandomCount();
	bool getUseNetwork();
	QList<QString> getNetworkAgents();

	void setUseRandom(bool);
	void setRandomCount(long);
	void setWindow(QRectF&);
	void setIterations(long);
	void setUseNetwork(bool);
	void setNetworkAgents(QList<QString>&);

	void save(QString&);


protected:
	bool useRandom;
	quint32 randomCount;
	quint32 iterations;
	QRectF window;
	QList<QString> networkAgents;
	bool useNetwork;

	friend QDataStream &operator<<(QDataStream &out, const ConfigurationLoader &myObj);
	friend QDataStream &operator>>(QDataStream &in, ConfigurationLoader &myObj); 
};

inline QDataStream &operator<<(QDataStream &out, const ConfigurationLoader &obj){
	return( out << obj.iterations << obj.randomCount << obj.useRandom << obj.window << obj.networkAgents << obj.useNetwork);
}
inline QDataStream &operator>>(QDataStream &in, ConfigurationLoader &obj){
	return( in >> obj.iterations >> obj.randomCount >> obj.useRandom >> obj.window >> obj.networkAgents >> obj.useNetwork);
}

#endif

