/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file fractale.h
 * \brief fichier de dfinition de la classe abstraite de fractale
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__fractale__
#define H__fractale__

#include <complex>
#include <QtGui>

/*! \class fractale
   * \brief classe abstraite de dfinition de fractale
   */
class fractale : public QObject{
	Q_OBJECT
public:
	 /*!
     *  \brief Constructeur.
     *
     *  \param s : nombre complexe caractristique de la suite fractale
	 *  \param i : nombre d'itrations maximum  considrer
     */
	fractale(std::complex<float>& s, long i):start(s), tmp(s), maxIterations(i), nbIterations(0){}
	fractale(){};
	/*!
     *  \brief Destructeur.
     */
	virtual ~fractale(){};
	virtual std::complex<float> next(std::complex<float>&)=0;
	virtual bool stop() = 0;
	virtual std::complex<float> renderingDestination(std::complex<float>&) = 0;
	void setMaxIterations(long i){
		maxIterations = i;
	}
	void setStart(std::complex<float> &s){
		start = s;
		nbIterations = 0;
	}
	int getMaxIterations(){ 
		return maxIterations;
	}
	inline virtual bool isVerticalSymetric() = 0;
	inline virtual bool isImpair() = 0;

	virtual fractale* clone()=0;
	virtual QString getName()=0;
protected:
	std::complex<float> start, tmp;
	long maxIterations, nbIterations;
};

#endif

