/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file fulllinear.cpp
 * \brief corps de la coloration fullLinear
 * \author Pierre Schwartz
 * \version 1.0
 */

#include "fulllinear.h"
#include <cmath>

fullLinear::fullLinear(int nbColors):colorMaker(nbColors){
}

fullLinear::~fullLinear(){
}

// level va de 0  999
QColor fullLinear::get(int level){
	int red, green, blue;

	//float ii = sqrt(sqrt(float(level)/nblevels)) * nblevels;
	int ii = level;

	if (level == 50)
		level++;

	// rouge
	if (ii < nblevels/4)
		red = 0;
	else if (ii < nblevels /2)
		red = -255 + 4*ii*255/nblevels;
	else
		red = 255;

	// vert
	if (ii< nblevels/2)
		green = 0;
	else if (ii < 3*nblevels/4)
		green = -510 + 4*ii*255/nblevels;
	else
		green = 255;

	// bleu
	if (ii< nblevels/4)
		blue = 4*255*ii/nblevels;
	else if (ii < nblevels/2)
		blue = 511 - 4*ii*255/nblevels;
	else if (ii < 3*nblevels/4)
		blue = 0;
	else 
		blue = -767 + 4*ii*255/nblevels;

	if (blue < 0) blue=0;
	if (blue > 255) blue = 255;
	if (green < 0) green = 0;
	if (green > 255) green = 255;
	if (red < 0) red = 0;
	if (red > 255) red = 255;

	return QColor(red, green, blue);
}