/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file imagecalculator.h
 * \brief fichier de gestion de la gnration multithreade et distribue de fractales gnriques
 * \author Pierre Schwartz
 * \version 1.0
 */


#ifndef H__ImageCalculator_H
#define H__ImageCalculator_H

#include <QtGui/QImage>
#include <QtCore/QVector>
#include <QtGui>

#include "fractale.h"
#include "imagetiler.h"
#include "networkimagetiler.h"

/*! 
 * \class ImageCalculator
 * \brief Cette classe gre le rendu global des images
 * \author Pierre Schwartz
 * \version 1.0
 */
class ImageCalculator : public QThread
{
	Q_OBJECT
 
	public :
		ImageCalculator(int nb, QImage *d, QRectF w, QSize r, fractale &f, bool type, long nbr, bool anim, QStringList &networkList);
		~ImageCalculator();

		void run();
		long maxValue;

		long inline getMaxValue(){
			return maxValue;
		}

		/*! 
		 * \brief rcuprer la valeur 1D stocke sur les 4 octets RGB
		 */
		static long inline RGBAToInt(QRgb r){
			int red = qRed(r);
			int green = qGreen(r);
			int blue = qBlue(r);
			int alpha = 0;//255-qAlpha(r);
			return (alpha << 24) + (red<<16) + (green<<8) + blue;
		}
		
		/*! 
		 * \brief crer un quadruplet RGBA  partir d'une valeur 1D
		 */
		static QRgb inline intToRGBA(long r){
			int alpha = r >> 24;
			r -= (alpha << 24);
			int red = r >> 16;
			r -= (red << 16);
			int green = r >> 8;
			r -= (green << 8);
			int blue = r;
			
			return QColor(red, green, blue, 255-alpha).rgb();
		}

		signals:
			void progress(int x);
			void render();		

		public slots :
			void s_processing();
	private:
		int nbThreads;
		QImage *destination;
		QRectF window;
		QSize size;
		fractale &frac;
		bool animate;
		bool shortcuts;
		bool useRandomCalculation;
		long nbRandom;
		int lastProgression;

		long nbProcessedRows;		// un simple compteur d'avancement

		QMutex mutex;
		QVector<QVector<long> > result;
		QStringList &networkAdresses;
		void sumImagesIntoDestination();

		QVector<ImageTiler*> tilers;
		QVector<NetworkImageTiler*> networkTilers;
};

#endif
