/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file imagetiler.h
 * \brief fichier de dfinition de la classe de calcul parralle
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__ImageTiler__
#define H__ImageTiler__

#include <QtCore/QThread>
#include <QtGui>

#include "fractale.h"

/*! \class ImageTiler
   * \brief gnre une partie de l'image
   */
class ImageTiler : public QThread{
	Q_OBJECT

public:
	ImageTiler(QVector<QVector<long> >&, QMutex&, QRectF w, QSize r, fractale *f, bool type, long nbRandom, int start, int step, int id);
	virtual ~ImageTiler();
	
	virtual void run();
	long maxValue;

	signals :
		void finished(long max);
		void processed();
protected :
	QRectF window;
	QSize size;
	fractale *frac;
	bool displayRandomPoints;
	long nbRandom;
	int start;
	int step;
	int id;
	QMutex &mutex;
	QVector<QVector<long> > &destinationArray;

	void processSinglePoint(std::complex<float>&, fractale*, float, float);
};

#endif

