/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

#ifndef H__julia__
#define H__julia__

#include "fractale.h"

/*! \class julia
   * \brief Classe de description des ensembles de Julia
   * \image html julia.png
   */
class julia : public fractale{
public:
	julia(std::complex<float>&, long);
	~julia();
	std::complex<float> next(std::complex<float>&);
	bool stop();
	std::complex<float> renderingDestination(std::complex<float>&);
	bool isVerticalSymetric(){return false;}
	bool isImpair(){return true;}

	julia* clone(){
		julia *b = new julia(start, maxIterations);	
		b->setOffset(offset);
		return b;
	}

	void setOffset(std::complex<float>);

	static QRectF getBestWindow(){
		return QRectF(-1.5,-1.5,3,3);
	}

	QString getName(){
		return QString("julia");
	}


protected:
	std::complex<float> offset;


};

#endif

