/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file lightningmaker.cpp
 * \brief corps de la classe de gestion d'clairage 3D
 * \author Pierre Schwartz
 * \version 1.0
 */

#include "lightningmaker.h"
#include "triplex.h"
#include "imagecalculator.h"

/*!
 * \brief Constructeur
 */
lightningMaker::lightningMaker(QVector<QVector<int> >& distanceMap, QVector<QVector<triplex> >& normalMap, QRectF& window, QSize resolution, QImage* destination, triplex camera, triplex light):distanceMap(distanceMap), window(window), destination(destination), camera(camera), light(light), normalMap(normalMap), resolution(resolution){
	stepx = window.width() / resolution.width();
	stepy = window.height() / resolution.height();
	stepz = stepx;
}

/*!
 * \brief Lancement du calcul. 
 Pour chaque point on dtermine le rayon lumineux incident, sa rflexion par rapport  
 la normale au point impact et la rsultante allant vers la camra
 */
void lightningMaker::run(){
	for (int i=0; i<distanceMap.count(); i++){
		for (int j=0; j<distanceMap[i].count(); j++){
			triplex N = normalMap[i][j];

			triplex point(window.left() + i*stepx, window.top() + j*stepy, window.left() + distanceMap[i][j]*stepz);

			triplex L = (point - camera).normalize();
			
			triplex R = N * 2 * (N.scalar(L)) - L;

			triplex V = (point - camera).normalize();
			float resultante = abs(V.scalar(R));
			destination->setPixel(i,j, ImageCalculator:: intToRGBA(1000 * resultante * resultante));
		}
	}
}
