/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file lightningmaker.h
 * \brief corps de la classe de gestion d'clairage 3D
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__lightningmaker__
#define H__lightningmaker__

#include <QtCore>
#include "triplex.h"


/*! 
 * \class lightningMaker
 * \brief Cette classe de gestion d'clairage 3D
 * \author Pierre Schwartz
 * \version 1.0
 */
class lightningMaker{
public:
	lightningMaker(QVector<QVector<int> >& distanceMap, QVector<QVector<triplex> >&, QRectF& window, QSize resolution, QImage* destination, triplex camera, triplex light);
	void run();
protected:
	QVector<QVector<int> >& distanceMap;
	QVector<QVector<triplex> > &normalMap;
	QRectF &window;
	QImage* destination;
	triplex camera, light;

	float stepx, stepy, stepz;
	QSize resolution;
};

#endif
