/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*! \mainpage Gnrateur de fractales DVP
 *
 * <img src="bateau.png"/>
 * \section what_sec De quoi s'agit-il ?
 * Documentation de ma participation au dfi Buddhabrot de la rubrique Qt de developpez.com (-> http://qt.developpez.com/defis/01-buddhabrot/)

 * \section func_sec Fonctionnalits 
 * L'application prsente ici permet d'afficher les fractales suivantes : <ul>
 *  <li>Buddhabrot</li>
 *  <li>Mandelbrot</li>
 *  <li>Ensembles de Julia</li>
 *  <li>Fractale de Newton</li>
 *  <li>Bateau en feu</li>
 *  <li>MultiBrot</li>
 *  <li>Tricorn</li>
 *	<li>Sharingan</li>
 *	<li>...</li>
 *  </ul>
 L'application permet de dfinir ses propres fractales. Il suffit pour cela d'crire un plugin. Chaque plugin tiendra dans un fichier de bibliothque  liaison dynamique qu'il vous suffira de copier dans le rpertoire /data/fractales/ . Un exemple de plugin est fourni dans l'archive (multibrot4).
 Chaque plugin accessible ajoutera un choix supplmentaire lors de la slection de la fractale  gnrer.

 * Sur chaque fractale, l'utilisateur peut zoomer/dzoomer. Le choix du nombre d'itrations de calcul dtermine la profondeur de la fractale. Plus le nombre d'itrations seront grand, plus le temps de calcul sera grand.
 * Une gnration non anime permet d'obtenir rapidement un rsultat, l'animation tant trs gourmande en ressources.<br/>
 * La gnration des fractales est multithreade en fonction des capacits du CPU. <br/>

 * \section render_sec Rendu point  point / alatoire
 L'application propose 2 types de rendu : point  point et par points alatoires.<br/>
 Le rendu point  point va dterminer une suite fractale correspondant  chaque pixel. On aura donc largeur*hauteurs suites droules. <br/>
 Le rendu alatoire va dterminer N suites fractales correspondants autant de points dtermins au hasard.<br/>
 Le bon effet graphique d'une fractale ou d'une autre dpend du choix du type de rendu : le MandelBrot est plus prcis en rendu point  point, tandis que le BuddhdaBrot sera plus prcis en rendu alatoire trs profond.

 * \section colo_sec Coloration 
 * L'application propose possde plusieurs mthodes de coloration des fractales : <ul>
 *	<li>En noir et blanc<img src="gray.png"/></li>
 *	<li>En dgrad du noir vers l'orange<img src="darkBody.png"/></li>
 *	<li>En dgrad du noir vers le bleu puis vers le blanc<img src="crystal.png"/></li>
 *	<li>En dgrad du noir vers le blanc en passant par le bleu, le rouge et le jaune<img src="fullLinear.png"/></li>
 *	<li>Une coloration scripte de dgrade du noir vers le vert<img src="Vert.png"/></li>
 *	<li>Une coloration scripte alatoire<img src="Psychedelique annees 70.png"/></li>
 *  </ul>
 *  L'utilisateur peut rajouter librement ses propres mthodes de coloration, il suffit pour cela d'implmenter
 * un fichier [Nomdufichier].js  dposer dans le rpertoire /data/palettes/. Ce fichier pourra tre accompagn d'une 
 * image [Nomdufichier].png place au mme endroit. Chaque palette de couleurs scripte ajoute un bouton la commandant 
 dans la zone de coloration de l'application,  la suite des colorations natives. Les colorations scriptes sont plus lentes que les colorations natives. <br/>
 Les scripts devront possder les 2 mthodes suivantes : 
 * <pre>({
init : function(nbLevels){
*	// traitement appel au chargement du script, permettant d'obtenir la granularit de la coloration, en nombre de niveau de couleur  gnrer
},
	
compute : function(i){
*	// renvoie un entier sous la forme des 3 octets RGB concatns dans cet ordre.
*	// i reprsente le niveau de la couleur  gnrer
}
})</pre>
 * La prsence du fichier .js suffit  inclure la coloration dans l'application.

 * \section optimize_sec Optimisations
 L'application utilise des conteneurs  accs en O(1) vers des types scalaires pour manipuler le plus rapidement possible
 toutes les donnes ncessaires. Le passage vers des objets Qt de rendu se fait  la fin de la gnration. <br/>
 Chaque fractale peut dfinir des proprits gomtriques de symtrie axiale ou centrale, le moteur de rendu exploitera
 ces informations pour ne calculer que les points ncessaires. On pourra donc aisment diviser par 2 le temps de rendu d'une 
 fractale symtrique.

 * \section rendureseau_sec Calcul distribu
 L'utilisateur a  la possibilit de spcifier des emplacements rseau comportant des agents de gnration. L'application 
 se chargera de rpartir les zones de calcul entre les diffrentes units de calcul locales et distantes. 
 Un agent de calcul rseau est dploy au travers d'un serveur web par le protocole HTTP. Un agent rseau consiste en 
 un fichier ready.php (indiquant qu'il est prt) et un fichier generate.php appelant une instance distante de la prsente application. 
 Des options de lancement particulires permettent de contrler le calcul d'une partie de l'image  gnrer.<br/>
 Ce dploiement via HTTP nous permet de nous affranchir de la gestion d'accs rseau, du contrle DOI, permet un ajout
 de logique de contrle tiers, de statistiques tierces, d'un load balancing, de logs ... bref de toutes les fonctionnalits
 fournies par (par exemple) un Apache.

 * \section i18n_sec Internationalisation
 L'internationalisation est gre au moyen de fichiers de traduction Qt, la prsente archive propose les traductions franaise & anglaise.

 * \section design_sec Design
 L'application utilise une feuille de style spcifique permettant d'outrepasser les styles du  systme de fentrage utilis.

 <br/><br/> 
 */

#include <QtGui/QApplication>
#include <QtCore/QTranslator>
#include <QtCore/QLocale>
#include <QtCore>

#include "app.h"
#include "commandlinearguments.h"
#include "networkagent.h"
/*!
 * \file main.cpp
 * \brief Fichier de dpart de l'application
 * \author Pierre Schwartz
 * \version 1.0
 */


int main(int argc, char *argv[]){
	QApplication app(argc, argv);

	/* 
		Analyser les ventuels arguments de la ligne de commande
	*/
	CommandLineArguments parser(argc, argv);
	if (parser.isNetworkAgent()){
		return NetworkAgent::process(parser);
	}else{

		/* 
			rcupration des traductions, j'ai mis par dfaut les traductions anglaises
			pour bien voir que le rsultat affich n'est pas celui du code source
		*/
		QTranslator qtTranslator;
		//qtTranslator.load("buddha_" + QLocale::system().name(), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
		qtTranslator.load("buddha_en");
		app.installTranslator(&qtTranslator);

		App widget;
		widget.show();	
		return app.exec();
	}
}