/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file mandelbrot3d.h
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__mandelbrot3d__
#define H__mandelbrot3d__

#include <QtCore>
#include "triplex.h"

/*! 
 * \class MandelBrot3d
 * \brief classe de calcul du MandelBrot 3D (MandelBulb)
 * \author Pierre Schwartz
 * \version 1.0
 * \image html mandelbulb.png
 */
class MandelBrot3d : public QObject{
Q_OBJECT
public:
	MandelBrot3d(QVector<QVector<int> >&, QVector<QVector<triplex> >&, QImage*, QRectF window, int reso, int iterations);
	int process();

	static QRectF getBestWindow(){
		return QRectF(-2,-1.5,3,3);
	}

signals:
	void progress(int);

private:
	QVector<QVector<int> > &projectedImage;
	QVector<QVector<triplex> >&normalMap;
	QRectF window;
	int reso;
	int iterations;
	triplex step;
	QImage *destination;

	bool processPoint(triplex&);
};


#endif

