#include "NetworkImageTiler.h"
#include <QtGui/QImage>
#include "ImageCalculator.h"
#include <QtGui/QMessageBox>


NetworkImageTiler::NetworkImageTiler(QString url, QVector<QVector<long> >& result, QMutex& mutex, QRectF w, QSize r, fractale *f, bool type, long nbRandom, int start, int step):result(result), mutex(mutex), size(r){
	surl = url.append(QString("/generate.php?t=%1&f=%2&w=%3&r=%4&i=%5&ra=%6&o=%7&s=%8")
		.arg(type?"true":"false")
		.arg(f->getName())
		.arg(QString("%1:%2:%3:%4")
			.arg(w.top()).arg(w.left()).arg(w.height()).arg(w.width())
			)
		.arg(r.width()) 
		.arg( f->getMaxIterations() )
		.arg(nbRandom)		
		.arg(start)
		.arg(step)
	);	


}

NetworkImageTiler::~NetworkImageTiler(){
}

void NetworkImageTiler::run(){
	QNetworkAccessManager manager;

	connect ( &manager, SIGNAL ( finished(QNetworkReply*)    ),   this , SLOT   ( s_finished(QNetworkReply*) )  );

	reply = manager.get(QNetworkRequest(QUrl(surl)));
	
	//connect ( reply, SIGNAL ( finished()    ),   this , SLOT   ( s_replyfinished() )  );
	//connect ( reply, SIGNAL ( error( QNetworkReply::NetworkError)    ),   this , SLOT   ( s_error(QNetworkReply::NetworkError) )  );

	loop.exec();
	QByteArray arr = reply->readAll();
	QImage img = QImage::fromData(arr);

	for (int i=0; i<size.width(); i++){
		mutex.lock();
		for (int j=0; j<size.height(); j++){
			result[i][j] += ImageCalculator::RGBAToInt(img.pixel(i,j));
		}
		mutex.unlock();
	}

	delete reply;
}


void NetworkImageTiler::s_error(QNetworkReply::NetworkError){
	loop.exit();
}


void NetworkImageTiler::s_finished(QNetworkReply*){
	loop.exit();
}