/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file networkimagetiler.h
 * \brief fichier de dfinition de la classe de calcul rseau
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__networkimagetiler__
#define H__networkimagetiler__

#include "imagetiler.h"
#include <QtCore/QThread>
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkAccessManager>

/*! \class NetworkImageTiler
   * \brief Cette classe gre l'appel d'un rendu webservice
   */

class NetworkImageTiler : public QThread{
	Q_OBJECT

public:
	NetworkImageTiler(QString, QVector<QVector<long> >&, QMutex&, QRectF w, QSize r, fractale *f, bool type, long nbRandom, int start, int step);
	~NetworkImageTiler();
	void run();
	public slots:
		void s_error(QNetworkReply::NetworkError e);
		void s_finished(QNetworkReply*);
	
protected:
	QString surl;
	QVector<QVector<long> >& result;
	QMutex& mutex;
	QNetworkReply* reply;
	QEventLoop  loop; 
	QSize size;
};

#endif
