/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file networkinput.cpp
 * \brief corps du widget de saisie d'agent rseau
 * \author Pierre Schwartz
 * \version 1.0
 */

#include "networkinput.h"

#include <QtGui/QHBoxLayout>
#include <QtGui/QPixmap>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QtGui/QMessageBox>


NetworkInput::NetworkInput():QWidget(){
	QHBoxLayout *layout = new QHBoxLayout();
	
	layout->setContentsMargins(0,0,0,0);
	edit = new QLineEdit();
	edit->setToolTip(tr("Adresse de l'agent rseau. http://toto.tata"));
	img = new QLabel();
	ready = false;

	setOrange();

	layout->addWidget(edit);
	layout->addWidget(img);

	setLayout(layout);
	timer = new QTimer(this);
	QObject::connect(timer, SIGNAL(timeout()), this, SLOT(s_checkReady()));
	QObject::connect(edit, SIGNAL(editingFinished ()), this, SLOT(s_checkReady()));
}


QString NetworkInput::getUrl(){
	return edit->text();
}

void NetworkInput::setUrl(QString u){
	edit->setText(u);
	s_checkReady();
}

bool NetworkInput::isReady(){
	return ready;
}

void NetworkInput::checkIfReady(){

}

void NetworkInput::s_checkReady(){
	QNetworkAccessManager * manager = new QNetworkAccessManager();
	
	connect(manager, SIGNAL(finished(QNetworkReply*)),
               this, SLOT(s_onReceiveReady(QNetworkReply*)));

	if (getUrl() != QString(""))
		manager->get(QNetworkRequest(QUrl(getUrl() + "/ready.php")));
}

void NetworkInput::s_onReceiveReady(QNetworkReply *reply){
	QVariant statusCodeV = 
    reply->attribute(QNetworkRequest::HttpStatusCodeAttribute);
     
    // no error received?
    if (reply->error() == QNetworkReply::NoError)
    { 
        QByteArray bytes = reply->readAll();  // bytes
        QString string(bytes); // string
		
		if (string == QString("ok")){
			setGreen();
		}else{
			setRed();
			emit message(QString(tr("Il n'y a pas d'agent rseau  cette adresse")));
		}
    }
    // Some http error received
    else
    {		
        // handle errors here
		setRed();
		emit message(reply->errorString());		
    }

	// toutes les 5 secondes, aller voir si l'agent rseau est l
	timer->start(5000);
}

void NetworkInput::setGreen(){
	ready = true;
	QPixmap map(QString("data/images/ok.png"));	
	img->setPixmap(map);
	img->setToolTip(tr("L'agent rseau est prt"));
}

void NetworkInput::setOrange(){
	ready = false;
	QPixmap map(QString("data/images/question.gif"));	
	img->setPixmap(map);
	img->setToolTip(tr("L'agent rseau n'est pas encore reconnu"));
}

void NetworkInput::setRed(){
	ready = false;
	QPixmap map(QString("data/images/fail.gif"));	
	img->setPixmap(map);
	img->setToolTip(tr("L'agent rseau n'est pas disponible, accessible ou prt"));
}