/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file networkinput.h
 * \brief fichier de dfinition du widget de saisie d'agent rseau
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__network_iput__
#define H__network_iput__

#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtNetwork/QNetworkReply>
#include <QtCore/QTimer>


/*! \class NetworkInput
   * \brief Cette classe reprsente une spcialisation de QLabel qui permet de saisir un agent rseau. Elle affiche galement une icne d'tat (orange/rouge/vert) rgulirement rvalue.
   */
class NetworkInput : public QWidget{
Q_OBJECT

public :
	NetworkInput();
	~NetworkInput(){};
	QString getUrl();
	void setUrl(QString);
	bool isReady();

signals:
	void message(const QString&);


public slots :
	void s_checkReady();
	void s_onReceiveReady(QNetworkReply*);	
private:
	QLineEdit *edit;
	QLabel *img;
	void checkIfReady();
	void setGreen();
	void setOrange();
	void setRed();

	bool ready;
	QTimer *timer;
};

#endif
