/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file scriptedcolormaker.cpp
 * \brief corps de la coloration scripte
 * \author Pierre Schwartz
 * \version 1.0
 */

#include "scriptedcolormaker.h"

scriptedColorMaker::scriptedColorMaker(int nbColors, QString paletteName):colorMaker(nbColors){
	QString name("data/palettes/");
	name.append(paletteName);
	name.append(".js");

    evaluatedFile = evaluateFile(engine, name);
	scriptedFunction = evaluatedFile.property("compute");

	QScriptValue constructor = evaluatedFile.property("init");
	constructor.call(evaluatedFile,QScriptValueList() << nblevels);
}

scriptedColorMaker::~scriptedColorMaker(){
}

/*!
*  \brief appel de la fonction distante et rcupration de la couleur.
*/
QColor scriptedColorMaker::get(int level){
	long result = scriptedFunction.call(evaluatedFile,QScriptValueList() << level << nblevels).toNumber();
	
	unsigned char r = result >> 16;
	unsigned char g = (result-(r << 16)) >> 8;
	unsigned char b = result-(r<<16) - (g<<8);

	return QColor(r, g, b);
}

/*!
*  \brief lit un script
*/
QScriptValue scriptedColorMaker::evaluateFile(QScriptEngine &engine, QString const &filename){
    QFile file(filename);
    file.open(QIODevice::ReadOnly);

    return engine.evaluate(file.readAll(),filename);
}