/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file sharingan.h
 * \brief fichier de dfinition de la classe de description du tricorn
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__sharingan__
#define H__sharingan__

#include "fractale.h"

/*! \class sharingan
   * \brief Classe de description du sharingan
   * \image html sharingan.png
   */
class sharingan : public fractale{
public:
	 /*!
     *  \brief Constructeur.
     *
     *  \param c : nombre complexe caractristique de la suite fractale
	 *  \param i : nombre d'itrations maximum  considrer
     */
	sharingan(std::complex<float>& c, long i);

	 /*!
     *  \brief Destructeur.
     */
	~sharingan();

	 /*!
     *  \brief Calcule la prochaine valeur de la suite.
     *
     *  \param c : valeur dont on cherche le suivant
	 *  \return nouveau point
     */
	std::complex<float> next(std::complex<float>&);

	 /*!
     *  \brief Faut-il arrter la suite ? Le sharingan s'arrte si le module du dernier lment est suprieur  2, la suite divergera.
	 *  \return oui/non
     */
	bool stop();

	 /*!
     *  \brief Dtermine quel point complexe on incrmente pour afficher le rsultat.
     *
     *  \param c : point que l'on souhaite reprsenter
	 *  \return point sur lequel on rendra le point c
     */
	std::complex<float> renderingDestination(std::complex<float>& c);

	 /*!
     *  \brief Cette fractale est-elle symtrique verticalement ? Le sharingan l'est.
	 *  \return oui
     */
	inline bool isVerticalSymetric(){return true;}

	 /*!
     *  \brief Cette fractale est-elle symtrique par rapport  l'origine du repre ? Le sharingan ne l'est pas.
	 *  \return non
     */
	inline bool isImpair(){return false;}

	sharingan* clone(){
		sharingan *b = new sharingan(start, maxIterations);
		return b;
	}

	static QRectF getBestWindow(){
		return QRectF(-1.5,-1.5,3,3);
	}

	QString getName(){
		return QString("sharingan");
	}
};

#endif

