/*
Copyright (C)2009 SCHWARTZ Pierre

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "zoomableimage.h"

ZoomableImage::ZoomableImage():QLabel(){
	setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
	setAlignment(Qt::AlignTop | Qt::AlignLeft);	
	setMouseTracking(true);
};


/*! 
* \brief ragit aux vnements double clic
*/
void ZoomableImage::mouseDoubleClickEvent ( QMouseEvent *e){
	if (e->button() == Qt::LeftButton)
		emit zoom(e->x(), e->y());
	else
		emit unzoom(e->x(), e->y());
}


/*! 
* \brief ragit aux vnements de mouvement de souris
*/
void ZoomableImage::mouseMoveEvent    ( QMouseEvent   * ev ){
	emit move(ev->pos().x(), ev->pos().y());
	return;
}