/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file zoomableimage.h
 * \brief fichier de dfinition du widget ZoomableImage.
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__zoomable_image__
#define H__zoomable_image__

#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QMouseEvent>

/*! \class ZoomableImage
   * \brief Cette classe reprsente une spcialisation de QLabel qui peut ragir 
   aux double clics gauche et droit ainsi que renvoyer les positions complexes survoles  la souris  
   */
class ZoomableImage : public QLabel{
Q_OBJECT

public :
	ZoomableImage();
	~ZoomableImage(){};
	void mouseDoubleClickEvent ( QMouseEvent *);
	void mouseMoveEvent   ( QMouseEvent   * );

signals:
	void zoom(int x, int y);
	void unzoom(int x, int y);
	void move(int x, int y);
};

#endif
