/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

#include "multibrot4.h"

multibrot4::multibrot4(){
}

multibrot4::multibrot4(std::complex<float>& c, long i):pluginfractale(c,i){
}

std::complex<float> multibrot4::next(std::complex<float>& c){
	return tmp = c*c*c*c + start;
}
bool multibrot4::stop(){
	return nbIterations >= maxIterations || (tmp.real()*tmp.real()+tmp.imag()*tmp.imag()>4);
}

std::complex<float> multibrot4::renderingDestination(std::complex<float>&){
	return start;
}

bool multibrot4::isVerticalSymetric(){
	return true;
}

bool multibrot4::isImpair(){
	return false;
}

fractale* multibrot4::clone(){
	multibrot4 *b = new multibrot4(start, maxIterations);
	return b;
}	
QString multibrot4::getName(){
	return QString("multibrot4");
}
 
Q_EXPORT_PLUGIN2(multibrot4, multibrot4)