/*
Copyright 2010 Pierre SCHWARTZ

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
documentation files (the "Software"), to deal in the Software without restriction, including without 
limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following 
conditions: The above copyright notice and this permission notice shall be included in all copies or 
substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*/

/*!
 * \file pluginfractale.h
 * \author Pierre Schwartz
 * \version 1.0
 */

#ifndef H__pluginfractale__
#define H__pluginfractale__

#include "fractale.h"


/*! \class pluginfractale
   * \brief Classe de description de plugin de fractale   
   */
class pluginfractale : public fractale{
Q_OBJECT
public:
	pluginfractale(){};
	pluginfractale(std::complex<float>& c, long i):fractale(c,i){};
	virtual ~pluginfractale(){};
	virtual std::complex<float> next(std::complex<float>&)=0;
	virtual bool stop() = 0;
	virtual std::complex<float> renderingDestination(std::complex<float>&) = 0;
	
	virtual bool isVerticalSymetric() = 0;
	virtual bool isImpair() = 0;

	virtual fractale* clone()=0;
	virtual QString getName()=0;
};

Q_DECLARE_INTERFACE(pluginfractale, "org.khayyam.pluginfractale/1.0")

#endif

