#include "accumulator.h"

Accumulator::Accumulator(FractalInfo * info, QObject * parent) :
		QObject(parent),
		_info(info)
{
}

unsigned int Accumulator::toY(const Complex &z )
{
	return ( info()->imageSize().height() - 1) * (z.imag() - info()->fractaleSize().y()) / info()->fractaleSize().height();
}

unsigned int Accumulator::toX(const Complex &z )
{
	return 	( info()->imageSize().width() - 1) * (z.real() - info()->fractaleSize().x()) / info()->fractaleSize().width();
}
