#ifndef ACCUMULATOR_H
#define ACCUMULATOR_H

#include <QObject>
#include <QPointF>
#include <QRectF>

#include "../complex.h"
#include "../fractalinfo.h"

/*!
 *	\class Accumulator
 *	\brief Interface permettant de definir un accumulateur de point
 *
 *	Cette classe permet d accumuler les points generer par un Generator
 *	Elle possde une unique methode qui accumule les points d'une sequence
 *	Cette accumulation se retrouve dans les pixels de la classe FractalInfo
 */
class Accumulator : public QObject
{
	FractalInfo * _info;

public:
	/// constructeur qui prend un FractalInfo pour accumuler les valeurs du fractale sur l'image
	Accumulator(FractalInfo * info, QObject * parent = 0);

	/// prend une sequence de point pour l'accumuler sur un pixel de l'image
	virtual void accumuler(Complex &pInit, QVector<Complex> &seq) = 0;

	/// retourne le FractalInfo
	inline FractalInfo * info() { return _info; }

protected:
	/// convertit un complex en pixel sur l'image (coord X)
	unsigned int toX(const Complex &z );
	/// convertit un complex en pixel sur l'image (coord Y)
	unsigned int toY(const Complex &z );
};

#endif // ACCUMULATOR_H
