#include "accumulatorfactory.h"

AccumulatorFactory::AccumulatorFactory(QObject *parent) :
    QObject(parent)
{
	_accumulatorNames << tr("Accumulation sur l'origine") << tr("Accumulation sur la squence");
}

AccumulatorFactory * AccumulatorFactory::_instance = NULL;

AccumulatorFactory * AccumulatorFactory::instance(QObject * parent)
{
	if( _instance == NULL )
		_instance = new AccumulatorFactory(parent);

	return _instance;
}

Accumulator * AccumulatorFactory::accumulator(QString name, FractalInfo * info, bool autoParam)
{
	if( _accumulatorNames[0] == name )
		return new OriginAccumulator(info, parent());

	if( _accumulatorNames[1] == name )
		return new SequenceAccumulator(info, parent());

	qCritical() << "Unknow accumulator : " << name;
	return NULL;
}
