#ifndef ACCUMULATORFACTORY_H
#define ACCUMULATORFACTORY_H

#include <QObject>
#include <QHash>

#include "accumulator.h"

#include "originaccumulator.h"
#include "sequenceaccumulator.h"

/*!
 *	\class AccumulatorFactory
 *	Ce singleton permet de creer un accumulateur par son nom
 *
 *	Pour chaque accumulateur dfini, il faut lui donner un nom pour etre creer
 *	Ce nom est defini dans cette classe
 *	Il est possible a partir d un nom de creer un objet implemantant la classe Accumulator
 *
 *	Pour toute creation d accumulateur, il est conseille de passer par cette factory
 */
class AccumulatorFactory : public QObject
{
//singleton part
	static AccumulatorFactory * _instance;
public:
	/// recupre l'instance de la factory
	static AccumulatorFactory * instance(QObject * parent = 0);

//factory
private:
	QStringList _accumulatorNames;
	//bloque l'instanciation
	explicit AccumulatorFactory(QObject *parent = 0);

public:
	/// retourne les noms des diffrents accumulateurs
	QStringList names() { return _accumulatorNames; }
	/*!
	 *	cr un accumulateur  partir de son nom
	 *	l'initialise avec le FractalInfo
	 *	affiche une fenetre de config si autoParam est mis a false
	 */
	Accumulator * accumulator(QString name, FractalInfo * info, bool autoParam = true);
};

#endif // ACCUMULATORFACTORY_H
