#include "sequenceaccumulator.h"

SequenceAccumulator::SequenceAccumulator(FractalInfo * info, QObject * parent) :
		Accumulator(info,parent)
{
}

void SequenceAccumulator::accumuler( Complex &pInit, QVector<Complex> &seq)
{
	if( seq.isEmpty() )
		return;

	QRect imageZone(QPoint(),info()->imageSize());

	for( int i = 0; i < seq.size(); i++) {
		QPoint imagePoint(toX(seq.at(i)), toY(seq.at(i)));
		if( imageZone.contains(imagePoint) ) {
			info()->incrPixel(imagePoint.x(), imagePoint.y() );
		}
	}
}
