#include "calculimage.h"

CalculImage::CalculImage(Generator * gen, Fractal * fractale, Accumulator * accu) :
		QThread(),
		_gen(gen),
		_fractale(fractale),
		_accu(accu)
{
	_watcher = new QFutureWatcher<void>(this);

	connect(_watcher, SIGNAL(progressValueChanged(int)), SLOT(progress(int)));
}

struct TestMap
{
	TestMap(Fractal * fractale, Accumulator * accu)
	 : _fractale(fractale), _accu(accu) { }

	void operator() (Complex &tmp)
	{
		QVector<Complex> sequence(_fractale->limit());
		_fractale->genererSequence(tmp,sequence);
		_accu->accumuler(tmp,sequence);
		sequence.clear();
	}

	Fractal * _fractale;
	Accumulator * _accu;
};

//extern void calcul(Complex tmp, Fractale * fractale, Accumulator * accu)
//{
//	QList<Complex> sequence;
//	fractale->genererSequence(tmp,sequence);
//	accu->accumuler(tmp,sequence);
//	sequence.clear();
//}

void CalculImage::run()
{
	FractalInfo * info = _accu->info();

	_result = QImage(info->imageSize(),QImage::Format_RGB32);

	//SANS THREAD
	//	while( _gen->next() ) {
	//		Complex tmp = _gen->getPoint();
	//		QList<Complex> sequence;
	//		_fractale->genererSequence(tmp,sequence);
	//		_accu->accumuler(tmp,sequence);
	//	}

	//AVEC RUN
	//	QList< QFuture<void> > list;
	//	while( _gen->next() ) {
	//		list << QtConcurrent::run(calcul, _gen->getPoint(), _fractale, _accu );
	//	}
	//
	//	for( int i = 0; i < list.size(); i++ )
	//		list[i].waitForFinished();

	//AVEC MAP
	QList<Complex> tmp;
	while( _gen->next() )
		tmp << _gen->getPoint();

	QFuture<void> test = QtConcurrent::map(tmp,TestMap(_fractale,_accu));

	emit setRange(test.progressMinimum(),test.progressMaximum());
	_watcher->setFuture(test);

	_watcher->cancel();

	test.waitForFinished();
}

QImage CalculImage::result()
{
	return _result;
}

void CalculImage::progress(int value) {
	emit progressValueChanged(value);
}
